#!/usr/bin/env python
# Hide Per Resource
# Copyright 2005 by Brian C. Christensen

#    This file is part of GanttPV.
#
#    GanttPV is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    GanttPV is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with GanttPV; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# 050704 - first version of this script

from wx.lib.dialogs import MultipleChoiceDialog as wxMultipleChoiceDialog

def hint(s):
    try:
        Data.Hint("%s: %s" % (scriptname, s))
    except AttributeError:
        self.SetStatusText(s)

def HidePerResource(self):
    """
    Set Hide flag on all task rows that aren't assigned selected resources
    """

    # set local pointers to tables
    rid = self.ReportID  # current report
    drep = Data.Database['Report']
    drow = Data.Database['ReportRow']
    drt = Data.Database['ReportType']
    dt = Data.Database['Task']
    da = Data.Database['Assignment']
    dres = Data.Database['Resource']
    rr = drep[rid]

    # make sure report has report type
    if not rr.has_key('ReportTypeID') or not drt.has_key(rr['ReportTypeID']): 
        if debug: print "ReportType key not found"
        hint("Error: Can't find type of this report.")
        return
    rtid = rr['ReportTypeID']

    # is this a task report
    rt = drt[rtid] # pointer to report type record
    ta = rt.get('TableA')
#    tb = rt.get('TableB')  # if two table report all inserts go at the end (less confusing to user)
#    if not (ta == 'Task' or tb == 'Task'):
    if (ta != 'Task'):
        hint('Use script only with Task reports.')
        return

    # find all visible rows
    rows = self.Report.table.rows  # all visible rows in display order
    # get row ids for all task rows
    rids = [ x for x in rows if drow[x].get('TableName') == 'Task' ]

    # get resources for visible rows
    visres = { }  # resource id's of visible rows -> points to row numbers
    for rowid in rids:
        # get task id
        tid = drow[rowid].get("TableID")
        if not tid or not dt.has_key(tid): continue  # silently skip invalid rows

        # look up assigned resources
        resids = [ da[x].get('ResourceID') for x in da.keys() 
            if da[x].get('TaskID') == tid and da[x].get('zzStatus') != 'deleted' ]
        # This scans Assignments once per task. I could build a list of tasks and then
        # just scan Assignments once using "in list of tasks".

        # keep track of visible rows
        for resid in resids:
            if visres.has_key(resid):
                visres[resid].append(rowid)
            else:
                visres[resid] = [ rowid ]

    # prepare list of resources for user selection
    picklist = [ (dres[x].get("Name") or "-", x) for x in visres.keys() ]
    picklist.sort()  # sort on resource name

    # make sure some results found
    if len(picklist) == 0:  # no assigned resource records
        hint("No resource are assigned to visible tasks, nothing changed.")
        return

    # prompt user for selection
    menutext = [ x[0] for x in picklist ]
    dlg = wxMultipleChoiceDialog(self,
                     "Select resources to keep visible:",
                        "Resources", menutext, style=wx.DEFAULT_FRAME_STYLE, size=(240, 320))
    dlg.Centre()
    if (dlg.ShowModal() != wx.ID_OK): return
    answer = dlg.GetValue()

    # make list of rowws to keep
    keeprows = [ ]
    for x in answer:
        resid = picklist[x][1]
        keeprows += visres[resid]

    print "keeprows", keeprows

    # hide all visible rows not in keep list
    for rowid in rids:
        if not rowid in keeprows:
            change = { 'Table': 'ReportRow', 'ID': rowid, 'Hidden': True }
            Data.Update(change)

    Data.SetUndo("Hide Per Resource")

HidePerResource(self)
